define("block_massaction/checkboxmanager",["exports","core/templates","core/notification","./massactionblock","core_courseformat/courseeditor","core_course/events"],(function(_exports,_templates,_notification,_massactionblock,_courseeditor,_events){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Checkbox manager amd module: Adds checkboxes to the activities for selecting and
   * generates a data structure of the activities and checkboxes.
   *
   * @module     block_massaction/checkboxmanager
   * @copyright  2022 ISB Bayern
   * @author     Philipp Memmel
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.setSectionSelection=_exports.initCheckboxManager=_exports.getTitleOfSection=_exports.getSelectedModIds=void 0,_templates=_interopRequireDefault(_templates),_events=_interopRequireDefault(_events);let localStateUpdating=!1,sectionsChanged=!1,sections=[],moduleNames=[];const sectionBoxes={};_exports.initCheckboxManager=()=>{const courseEditor=(0,_courseeditor.getCurrentCourseEditor)(),eventsToListen_SECTION_UPDATED="section:updated",eventsToListen_CHANGE_FINISHED="transaction:end";courseEditor.stateManager.target.addEventListener(_events.default.stateChanged,(event=>{event.detail.action===eventsToListen_SECTION_UPDATED&&(sectionsChanged=!0),event.detail.action===eventsToListen_CHANGE_FINISHED&&rebuildLocalState()})),sectionsChanged=!0,rebuildLocalState()};const rebuildLocalState=()=>{if(localStateUpdating)return;localStateUpdating=!0;for(const prop of Object.getOwnPropertyNames(sectionBoxes))delete sectionBoxes[prop];const courseEditor=(0,_courseeditor.getCurrentCourseEditor)(),state=courseEditor.stateManager.state,courseItems=courseEditor.getExporter().allItemsArray(state);sections=[],courseItems.forEach((item=>{if("section"===item.type){let sectioninfo={...state.section.get(item.id)};sectioninfo.title=getTitleOfSection(sectioninfo),sections.push(sectioninfo)}})),moduleNames=[...courseEditor.stateManager.state.cm.values()];const sectionsUnfiltered=sections;sections=filterVisibleSections(sections),updateSelectionAndMoveToDropdowns(sections,sectionsUnfiltered),addCheckboxesToDataStructure(),localStateUpdating=!1},getTitleOfSection=section=>{let title=section.title;return"mod_subsection"===section.component&&(title=" - "+title),title};_exports.getTitleOfSection=getTitleOfSection;_exports.getSelectedModIds=()=>{const moduleIds=[];for(let sectionNumber in sectionBoxes)for(let i=0;i<sectionBoxes[sectionNumber].length;i++){document.getElementById(sectionBoxes[sectionNumber][i].boxId).checked&&moduleIds.push(sectionBoxes[sectionNumber][i].moduleId)}return moduleIds};const setSectionSelection=(value,sectionNumber)=>{const boxIds=[];if(void 0===sectionNumber||sectionNumber!==_massactionblock.constants.SECTION_SELECT_DESCRIPTION_VALUE){if(void 0!==sectionNumber&&sectionNumber===_massactionblock.constants.SECTION_NUMBER_ALL_PLACEHOLDER)for(const sectionId in sectionBoxes)for(let j=0;j<sectionBoxes[sectionId].length;j++)boxIds.push(sectionBoxes[sectionId][j].boxId);else sectionBoxes[sectionNumber].forEach((box=>boxIds.push(box.boxId)));for(let i=0;i<boxIds.length;i++)document.getElementById(boxIds[i]).checked=value;document.getElementById(_massactionblock.cssIds.SECTION_SELECT).value=_massactionblock.constants.SECTION_SELECT_DESCRIPTION_VALUE}};_exports.setSectionSelection=setSectionSelection;const addCheckboxesToDataStructure=()=>{sections.forEach((section=>{sectionBoxes[section.number]=[];const moduleIds=section.cmlist;if(moduleIds&&moduleIds.length>0&&""!==moduleIds[0]){moduleNames.filter((modinfo=>moduleIds.includes(modinfo.id.toString()))).forEach((modinfo=>{if("subsection"!==modinfo.module){const boxId=_massactionblock.usedMoodleCssClasses.BOX_ID_PREFIX+modinfo.id.toString();sectionBoxes[section.number].push({moduleId:modinfo.id.toString(),boxId:boxId})}}))}}))},filterVisibleSections=sections=>sections.filter((section=>0!==section.cmlist.length)).filter((section=>section.cmlist.every((moduleid=>null!==document.getElementById(_massactionblock.usedMoodleCssClasses.MODULE_ID_PREFIX+moduleid))))),updateSelectionAndMoveToDropdowns=(sections,sectionsUnfiltered)=>{sectionsChanged?(_templates.default.renderForPromise("block_massaction/section_select",{sections:sectionsUnfiltered}).then((_ref=>{let{html:html,js:js}=_ref;return _templates.default.replaceNode("#"+_massactionblock.cssIds.SECTION_SELECT,html,js),disableInvisibleAndEmptySections(sections),document.getElementById(_massactionblock.cssIds.SECTION_SELECT).addEventListener("change",(event=>setSectionSelection(!0,event.target.value)),!1),!0})).catch((ex=>(0,_notification.exception)(ex))),_templates.default.renderForPromise("block_massaction/moveto_select",{sections:sectionsUnfiltered}).then((_ref2=>{let{html:html,js:js}=_ref2;return _templates.default.replaceNode("#"+_massactionblock.cssIds.MOVETO_SELECT,html,js),disableUnavailableSections(_massactionblock.cssIds.MOVETO_SELECT),!0})).catch((ex=>(0,_notification.exception)(ex))),_templates.default.renderForPromise("block_massaction/duplicateto_select",{sections:sectionsUnfiltered}).then((_ref3=>{let{html:html,js:js}=_ref3;return _templates.default.replaceNode("#"+_massactionblock.cssIds.DUPLICATETO_SELECT,html,js),disableUnavailableSections(_massactionblock.cssIds.DUPLICATETO_SELECT),!0})).catch((ex=>(0,_notification.exception)(ex)))):disableInvisibleAndEmptySections(sections),sectionsChanged=!1},disableInvisibleAndEmptySections=sections=>{Array.prototype.forEach.call(document.getElementById(_massactionblock.cssIds.SECTION_SELECT).options,(option=>{option.value===_massactionblock.constants.SECTION_SELECT_DESCRIPTION_VALUE||sections.some((section=>parseInt(option.value)===section.number))?option.disabled=!1:option.disabled=!0}))},disableUnavailableSections=elementId=>{if(null!==document.getElementById(elementId)){const sectionsAvailableInfo=document.querySelector(_massactionblock.cssIds.SECTION_FILTER_DATA).dataset.availabletargetsections,sectionsAvailable=Array.prototype.map.call(sectionsAvailableInfo.split(","),(sectionnum=>parseInt(sectionnum)));Array.prototype.forEach.call(document.getElementById(elementId).options,(option=>{sectionsAvailable.includes(parseInt(option.value))?option.disabled=!1:option.disabled=!0}))}}}));

//# sourceMappingURL=checkboxmanager.min.js.map